local base = _G

module('me_bullseye')

local require = base.require

-- Модули LuaGUI
local loader				= require('DialogLoader')
local mod_mission			= require('me_mission')
local MapWindow				= require('me_map_window')
local U						= require('me_utilities')	-- Утилиты создания типовых виджетов
local ListBoxItem			= require('ListBoxItem')
local CoalitionController	= require('Mission.CoalitionController')
local CoalitionUtils		= require('Mission.CoalitionUtils')
local UC					= require('utils_common')
local OptionsData			= require('Options.Data')

local TableUtils			= require('TableUtils')
local log      				= require('log')

-- by uboats and MisterOutofTime ver 1.2
local MeSettings	        = require('MeSettings')
local Terrain    		    = require('terrain')
local TheatreOfWarData	    = require('Mission.TheatreOfWarData')
local i18n				    = require('i18n')
local Button			= require('Button')
local Skin				= require('Skin')
local SkinUtils			= require('SkinUtils')
local UpdateManager 	= require('UpdateManager')
local toolbar 			= require('me_toolbar')
local Static            = require('Static')
local textutil          = require('textutil')
local Tools = require("tools")
local _ = i18n.ptranslate

local panelTownList
local TLGrid
local btnRstScale

local TLdata_     = {}
local TLidx_      = 0
local pairs = base.pairs
-- by uboats and MisterOutofTime
local tostring = base.tostring

base.require('i18n').setup(_M)

-------------------------------------------------------------------------------
--
function initModule()
    -- Переменные загружаемые/сохраняемые данные 
    vdata =
    {
		coalition   = 'red',
		coordX = 0,
		coordY = 0,
    }
end;

-------------------------------------------------------------------------------
-- Создание и размещение виджетов
-- Префиксы названий виджетов: t - text, b - button, c - combo, sp - spin, sl - slider, e - edit, d - dial 
function create(x, y, w, h)
    local localization = {
        title 		= _('BULLSEYE OBJECT'),
		coalition	= _('coalition'),
		coordX		= _('COORD X'),
		coordY		= _('COORD Y'),
		long 		= _('LONG'),
        lat 		= _('LAT'),		
		-- by uboats and MisterOutofTime
        TownName	   = _('Location'),
		TownLat		   = _('LONG'),
        TownLon		   = _('LAT'),
        BtnRstScale    = _('Reset FOV'),
    }
	
	window = loader.spawnDialogFromFile('MissionEditor/modules/dialogs/me_bullseye.dlg', localization)
    window:setBounds(x, y, w, h)
	
	window:addMouseDoubleDownCallback(function(self, x, y, button)
		setDefaultPosition()
	end)
	
	window:addPositionCallback(function()
			local xWin, tmpY = window:getPosition()
			if xWin < base.toolbar.width then
				xWin = base.toolbar.width
			end
			
			window:setPosition(xWin, y_)
        end) 
	
	x_	= x	
	y_ 	= y	
	w_ 	= w
	
	function window:onClose()
        MapWindow.setState(MapWindow.getPanState())
        show(false)
        base.toolbar.setStaticButtonState(false)
        base.panel_units_list.show(false)
        MapWindow.unselectAll()
		
		-- by uboats and MisterOutofTime
		TLclear()
    end
	
    c_caol = window.c_caol
	
	local coalitionNames = {
		CoalitionController.blueCoalitionName(),
		CoalitionController.redCoalitionName(),
	}
	
	base.table.insert(coalitionNames, CoalitionController.neutralCoalitionName())
	
	CoalitionUtils.fillComboListCoalition(c_caol, coalitionNames, function(coalitionName)
		vdata.coalition = coalitionName
		update()
		
		MapWindow.selectBullseye(coalitionName)		
	end)

	---------------------------------------------------------------------------
	tt_long = window.tt_long
    tt_lat = window.tt_lat	
	
	-- by uboats and MisterOutofTime
	panelTownList 			= window.panelTownList
	TLGrid 					= panelTownList.Grid
	btnRstScale				= panelTownList.btnRstScale
		
	btnRstScale.onChange	= onChange_bRstScale
	
	TLinit()
end


-------------------------------------------------------------------------------
-- Открытие/закрытие панели
function show(b, a_coal)
	if b then
		TLinit()
		update()  
	end

    window:setVisible(b)
end


-------------------------------------------------------------------------------
--
function update()
    if vdata.coalition then
		vdata.coordX = mod_mission.mission.bullseye[vdata.coalition].x
		vdata.coordY = mod_mission.mission.bullseye[vdata.coalition].y
		
		CoalitionUtils.setComboListCoalition(c_caol, vdata.coalition)
	end
	
	if (e_coordX) then
		e_coordX:setText(vdata.coordX)
	end
	if (e_coordX) then
		e_coordY:setText(vdata.coordY)
	end
	
	-- возвращает lat, long в градусах
	local lat, long = MapWindow.convertMetersToLatLon(vdata.coordX, vdata.coordY)
    tt_lat:setText(U.getLatitudeString(U.toRadians(lat)))
    tt_long:setText(U.getLongitudeString(U.toRadians(long)))
end

-------------------------------------------------------------------------------
--
function setCameraToBullseye()
	MapWindow.setCamera(vdata.coordX, vdata.coordY)
end

function isVisible()
	if window then
		return window:getVisible() == true
	end
	return false
end

function setDefaultPosition()
	if window then
		window:setPosition(x_, y_)
		
		MapWindow.movePanelsGroupProp(x_, base.top_toolbar_h + base.right_toolbar_h)
	end	
end


-- by uboats and MisterOutofTime
function setCameraToTown(coordx, coordy)
	if MapWindow then
		MapWindow.setCamera(coordx, coordy)
	end
end

function convertTownCoord(lat, lon)
	local x = 0
	local y = 0
	local valid = false
	
	if Terrain then
		valid = true
		x, y = Terrain.convertLatLonToMeters(lat, lon)
	end
	
	return valid, x, y
end

function TLclear()
	if TLdata_ then
		for k, v in base.pairs(TLdata_) do v = nil end
	end
	TLdata_ = {}
end

function TLinit()
	TLclear()
	initTLGrid()
end

function insertRowTL(a_townname, a_lat, a_lon)
	local rowIndex = TLGrid:getRowCount()
	local optIndex = rowIndex + 1
    TLGrid:insertRow(20,rowIndex)
	
    ------1
	local cell_1
    cell_1 = Button.new(a_townname)
	cell_1.town = {a_lat,a_lon}
	cell_1:setSkin(Skin.buttonSkin_MENew())
	cell_1:setText(a_townname)	
	cell_1:addChangeCallback(function(self)
		local valid, x, y = convertTownCoord(self.town[1], self.town[2])
		if valid and MapWindow then
			MapWindow.focusPointMap(x, y)
			MapWindow.setScale(15000)
			--insertRowTL(selectedRowIndex, lat, lon)
			--insertRowTL(selectedRowIndex, x, y)
		end
	end)
	cell_1.val = a_townname
    TLGrid:setCell(0, rowIndex, cell_1)
    
    ------2
	local cell_2
    cell_2 = Static.new(a_lat)
	cell_2.val = a_lat
    TLGrid:setCell(1, rowIndex, cell_2)
	
    ------3
	local cell_3
    cell_3 = Static.new(a_lon)
	cell_3.val = a_lon
    TLGrid:setCell(2, rowIndex, cell_3)
	
end

function initTLGrid()
	base.print("init town list grid")
	TLGrid:clearRows()
	local town_data = getTerrainData()
	
	TLdata_ = {}
	TLidx_  = 0
	if town_data then
		base.print("town list not empty")
		for k,v in base.pairs(town_data) do
			TLidx_ = TLidx_ + 1
			TLdata_[TLidx_] = { key = k, disp = v.display_name, lat = v.latitude, lon = v.longitude}
			base.print("town list insert" .. v.display_name)
			--insertRowTL(v.display_name, v.latitude, v.longitude)
		end
	end
	
	if TLidx_ > 0 then
		base.table.sort(TLdata_, compareTbl)
		for k,v in base.pairs(TLdata_) do
			insertRowTL(v.disp, v.lat, v.lon)
		end
	end
end	

function onChange_bRstScale(self) 
	if MapWindow then
		MapWindow.setScale(600000)
	end
end

function compareTbl(tab1, tab2)
	return textutil.Utf8Compare(tab1["key"], tab2["key"])
end

function getTerrainData(terrain)
	if terrain == "GermanyCW" then
		terrain = "GermanyColdWar"
	end
	
	-- local hasTowns, towns = pcall(function()
	-- loadfile(TheatreOfWarData.getMapFolder() .. "/map/towns.lua")()
	-- return towns
	-- end)

	local towns = {}
	local path  = TheatreOfWarData.getMapFolder() .. 'map/towns.lua'
	function loadTowns(path)
		local data = Tools.safeDoFileWithDofile(path)
		if data then 
		return data.towns
		end
	end
	-- local fenv = {
	-- 	err= "",
	-- 	tostring = tostring,
	-- 	log = log,
		
	-- 	require = function (...)
	-- 		return {translate = _}
	-- 	end,
		
	-- }
	-- base.setfenv(loadTowns,fenv)
	towns = loadTowns(path)
	
	---- test table
	-- towns = {
	-- 	["AMBROLAURI"] = { latitude = 42.530195, longitude = 43.150121, display_name = _("AMBROLAURI")},
	-- 	["KUTAISI"] = { latitude = 42.267086, longitude = 42.696849, display_name = _("KUTAISI")},
	-- 	["BATUMI"] = { latitude = 41.654059, longitude = 41.655372, display_name = _("BATUMI")},
	-- 	["POTI"] = { latitude = 42.157804, longitude = 41.677693, display_name = _("POTI")},
	-- 	["ZUGDIDI"] = { latitude = 42.516379, longitude = 41.879016, display_name = _("ZUGDIDI")},
	-- 	["MAYKOP"] = { latitude = 44.607053, longitude = 40.096197, display_name = _("MAYKOP")},
	-- 	["KRASNODAR"] = { latitude = 45.053964, longitude = 39.000128, display_name = _("KRASNODAR")},
	-- 	["NOVOROSSIYSK"] = { latitude = 44.719335, longitude = 37.751757, display_name = _("NOVOROSSIYSK")},
	-- 	["KISLOVODSK"] = { latitude = 43.913866, longitude = 42.723910, display_name = _("KISLOVODSK")},
	-- 	["SUKHUMI"] = { latitude = 43.010963, longitude = 40.999400, display_name = _("SUKHUMI")},
	-- 	["SOCHI"] = { latitude = 43.604619, longitude = 39.721483, display_name = _("SOCHI")},
	-- 	["NAL'CHIK"] = { latitude = 43.485073, longitude = 43.623441, display_name = _("NAL'CHIK")},
	-- 	["PYATIGORSK"] = { latitude = 44.052891, longitude = 43.048264, display_name = _("PYATIGORSK")},
	-- 	["MINERAL'NYE VODY"] = { latitude = 44.201454, longitude = 43.137392, display_name = _("MINERAL'NYE VODY")},
	-- }

	return towns
end

-- by uboats and MisterOutofTime

initModule()

